% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reviewr_dev.R
\name{dev_add_data_model}
\alias{dev_add_data_model}
\title{Develop Data Model Table Functions}
\usage{
dev_add_data_model(csv)
}
\arguments{
\item{csv}{\emph{Required}. The file path of a CSV file containing a data model schema}
}
\value{
A .R file populated with basic database table functions
}
\description{
This function will assist in adding support for a new data model to
ReviewR. A schema file, supplied as a CSV, will be added to the package
namespace such that upon connection to a database containing the new data
model, ReviewR can identify and display it through the database detection
module.

Users will be prompted to identify which table in the new data model
contains a list of all patients. Additionally, users will be asked to
select which field uniquely identifies each patient. This field \emph{must}
be present across all tables in the new data model for best results.

Once selections are captured, a database_tables.R file will be populated
and opened for editing in RStudio. Basic table skeletons are created based
on the provided schema and user selections.

Note: If the identifier field is not present across all tables, care
must be taken to adjust the database_tables.R file to appropriately
represent the new data model structure.
}
\seealso{
Other Development Functions: 
\code{\link{dev_add_database_module}()}
}
\concept{Development Functions}
