% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WALD.R
\name{WALD}
\alias{WALD}
\title{The Wald family}
\usage{
WALD(mu.link = "log", sigma.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a WALD distribution in the \code{gamlss()} function.
}
\description{
The function \code{WALD()} defines the wALD distribution, two-parameter
continuous distribution for a \code{gamlss.family} object to be used in GAMLSS fitting
using the function \code{gamlss()}.
}
\details{
The Wald distribution with parameters \eqn{\mu} and \eqn{sigma} has density given by

\eqn{\operatorname{f}(x |\mu, \sigma)=\frac{\sigma}{\sqrt{2 \pi x^3}} \exp \left[-\frac{(\sigma-\mu x)^2}{2x}\right ], x>0 }
}
\examples{
# Example 1
# Generating random values with
# known mu and sigma
require(gamlss)
mu <- 1.5
sigma <- 4.0

y <- rWALD(10000, mu, sigma)

mod1 <- gamlss(y~1, sigma.fo=~1,  family="WALD",
               control=gamlss.control(n.cyc=5000, trace=TRUE))

exp(coef(mod1, what="mu"))
exp(coef(mod1, what="sigma"))

# Example 2
# Generating random values under some model

# A function to simulate a data set with Y ~ WALD
gendat <- function(n) {
  x1 <- runif(n)
  x2 <- runif(n)
  mu <- exp(0.75 - 0.69 * x1)   # Approx 1.5
  sigma <- exp(0.5 - 0.64 * x2) # Approx 1.20
  y <- rWALD(n, mu, sigma)
  data.frame(y=y, x1=x1, x2=x2)
}

dat <- gendat(n=200)

mod2 <- gamlss(y~x1, sigma.fo=~x2, family=WALD, data=dat, 
               control=gamlss.control(n.cyc=5000, trace=TRUE))

summary(mod2)

}
\references{
Heathcote, A. (2004). Fitting Wald and ex-Wald distributions to 
response time data: An example using functions for the S-PLUS package. 
Behavior Research Methods, Instruments, & Computers, 36, 678-694.
}
\seealso{
\link{dWALD}.
}
\author{
Sofia Cuartas García, \email{scuartasg@unal.edu.co}
}
