% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WG.R
\name{WG}
\alias{WG}
\title{The Weibull Geometric family}
\usage{
WG(mu.link = "log", sigma.link = "log", nu.link = "logit")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}

\item{nu.link}{defines the nu.link, with "log" link as the default for the nu parameter.}
}
\value{
Returns a gamlss.family object which can be used to fit a WG distribution in the \code{gamlss()} function.
}
\description{
The Weibull Geometric distribution
}
\details{
The weibull geometric distribution with parameters \code{mu},
\code{sigma} and \code{nu} has density given by

\eqn{f(x) = (\sigma \mu^\sigma (1-\nu) x^(\sigma - 1) \exp(-(\mu x)^\sigma)) 
(1- \nu \exp(-(\mu x)^\sigma))^{-2},}

for \eqn{x > 0}, \eqn{\mu > 0}, \eqn{\sigma > 0} and \eqn{0 < \nu < 1}.
}
\examples{
# Example 1
# Generating some random values with
# known mu, sigma and nu
y <- rWG(n=100,  mu = 0.9, sigma = 2, nu = 0.5)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, sigma.fo=~1, nu.fo=~1, family='WG',
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma and nu
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))
exp(coef(mod, what='nu'))

# Example 2
# Generating random values under some model
n     <- 200
x1    <- runif(n)
x2    <- runif(n)
mu    <- exp(- 0.2 * x1)
sigma <- exp(1.2 - 1 * x2)
nu    <- 0.5
x     <- rWG(n=n, mu, sigma, nu)

mod <- gamlss(x~x1, mu.fo=~x1, sigma.fo=~x2, nu.fo=~1, family=WG,
              control=gamlss.control(n.cyc=50000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
coef(mod, what='nu')
}
\references{
\insertRef{barreto2011weibull}{RelDists}
}
\seealso{
\link{dWG}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
