% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisher.method.R
\name{fisher.method}
\alias{fisher.method}
\title{Fisher's Method}
\usage{
fisher.method(p.values)
}
\arguments{
\item{p.values}{A vector containing the p-values from the single tests.}
}
\value{
A \code{"htest"} object with elements:
  \item{statistic}{Value of the test statistic.}
  \item{parameter}{Degrees of freedom.}
  \item{p.value}{P-value.}
  \item{method}{A character string indicating the type of test performed.}
  \item{data.name}{A character string giving the name of the data.}
}
\description{
Performs Fisher's method, which is used to combine the p-values
  from several independent tests bearing upon the same overall null 
  hypothesis.
}
\details{
Fisher's method (Fisher, 1925) combines the p-values from \eqn{k} 
  independent tests, into one test statistic using the following formula:
  \deqn{-2 \sum_{i=1}^{k} \log(p_{i}) \sim \chi_{2k}^{2},}
  where \eqn{p_i} is the p-value for the \eqn{i}th hypothesis test.
  
  For example, Foster and Stuart (1954) proposed this method to combine the
  information of the p-values from the \eqn{D} and \eqn{S}-statistics (see 
  Examples), since they are independent.
}
\examples{
# Join the independent p-values of the D and S-statistics
fisher.method(c(foster.test(ZaragozaSeries, statistic = "D")$p.value,
  foster.test(ZaragozaSeries, statistic = "S")$p.value))
# Adding weights
fisher.method(c(foster.test(ZaragozaSeries, weights = function(t) t-1, statistic = "D")$p.value,
  foster.test(ZaragozaSeries, weights = function(t) t-1, statistic = "S")$p.value))

}
\references{
Fisher RA (1925). 
\emph{Statistical Methods for Research Workers}. 
Oliver and Boyd, Edinburgh. 

Foster FG, Stuart A (1954). 
“Distribution-Free Tests in Time-Series Based on the Breaking of Records.”
\emph{Journal of the Royal Statistical Society B}, 
\strong{16}(1), 1-22.
\doi{10.1111/j.2517-6161.1954.tb00143.x}.
}
\seealso{
\code{\link{brown.method}}, \code{\link{foster.test}}
}
\author{
Jorge Castillo-Mateo
}
