% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryReSurvPredict.R
\name{plot.ReSurvPredict}
\alias{plot.ReSurvPredict}
\title{Plot of the development factors}
\usage{
\method{plot}{ReSurvPredict}(
  x,
  granularity = "input",
  group_code = 1,
  color_par = "royalblue",
  linewidth_par = 2.5,
  ylim_par = NULL,
  ticks_by_par = NULL,
  base_size_par = NULL,
  title_par = NULL,
  x_text_par = NULL,
  plot.title.size_par = NULL,
  ...
)
}
\arguments{
\item{x}{"ReSurvPredict" object specifying hazard and development factors.}

\item{granularity}{\code{character}, either \code{"input"} for \code{input_time_granularity} or \code{"output"} for \code{output_time_granularity}.}

\item{group_code}{\code{numeric}: Identifier for the group that will be plotted. Default is 1. The code identifiers can be find in the \code{ReSurvPredict$long_triangle_format_out} list. Depending on the granularity of interest, it will be either in \code{ReSurvPredict$long_triangle_format_out$input_granularity} for \code{input_time_granularity} or \code{ReSurvPredict$long_triangle_format_out$output_granularity} for \code{output_time_granularity}.}

\item{color_par}{\code{character}: \code{ggplot2} Colour of the line plot. Default is \code{'royalblue'}. Optional.}

\item{linewidth_par}{\code{numeric}: Line plot width. Optional.}

\item{ylim_par}{\code{numeric}: Highest intercept on the y-axis (development factors). The default is the highest predicted development factor. Optional.}

\item{ticks_by_par}{\code{numeric}: gap between each x-axis label (development period). Default is 2. Optional.}

\item{base_size_par}{\code{numeric}: base size of the plot. Default is 5. See \code{base_size} in the \code{?theme_bw} documentation. Optional.}

\item{title_par}{\code{character}: Title of the plot. Optional.}

\item{x_text_par}{\code{character}: Text on the x-axis. Optional.}

\item{plot.title.size_par}{\code{numeric}: size of the plot title. Default is 20. See \code{size} in the \code{?element_text} documentation. Optional.}

\item{...}{Other arguments to be passed to Plot. Optional.}
}
\value{
\code{ggplot2} of the development factors
}
\description{
Plots the development factors by group code.
}
