% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{simplify}
\alias{simplify}
\title{Retrieves closest single ancestor within a given set of SNOMED CT
concepts}
\usage{
simplify(
  conceptIds,
  ancestorIds,
  SNOMED = getSNOMED(),
  tables = c("RELATIONSHIP", "STATEDRELATIONSHIP")
)
}
\arguments{
\item{conceptIds}{character or integer64 vector of SNOMED concept IDs
for concepts for which an ancestor is sought}

\item{ancestorIds}{character or integer64 vector of SNOMED concept IDs
for possible ancestors}

\item{SNOMED}{environment containing a SNOMED dictionary}

\item{tables}{character vector of relationship tables to use}
}
\value{
a data.table with the following columns:
  originalId (integer64) = original conceptId,
  ancestorId (integer64) = closest single ancestor, or original
  concept ID if no ancestor is included among ancestorIds
}
\description{
Returns a vector of SNOMED CT concept IDs for an ancestor of each
concept that is within a second list. If multiple ancestors are
included in the second list, the concept is not simplified (i.e.
the original concept ID is returned).
This functionality can be used to translate concepts into simpler
forms for display, e.g. 'Heart failure' instead of 'Heart failure
with reduced ejection fraction'.
}
\details{
This function is intended for use with active SNOMED CT concepts only.
}
\examples{
SNOMED <- sampleSNOMED()

original_terms <- c('Systolic heart failure', 'Is a',
  'Heart failure with reduced ejection fraction',
  'Acute kidney injury due to circulatory failure (disorder)')
# Note in this example 'Is a' has no parents in ancestors,
# and acute kidney failure has two parents in ancestors
# so neither of the parents will be chosen.
# Also test out inclusion of duplicate concepts.

ancestors <- simplify(c(as.SNOMEDconcept(original_terms),
  as.SNOMEDconcept(original_terms)[3:4]),
  as.SNOMEDconcept(c('Heart failure', 'Acute heart failure',
  'Cardiorenal syndrome (disorder)')))
print(cbind(original_terms, description(ancestors$ancestorId)$term))
}
