% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{using}
\alias{using}
\title{\code{using} combinator allows us to manipulate results from a parser, for 
example building a parse tree. The parser \code{(p \%using\% f)} has the same 
behaviour as the parser \code{p}, except that the function \code{f} is
applied to each of its result values.}
\usage{
using(p, f)
}
\arguments{
\item{p}{is the parser to be applied}

\item{f}{is the function to be applied to each result of \code{p}.}
}
\value{
The parser \code{(p \%using\% f)} has the same behaviour as the
  parser \code{p}, except that the function \code{f} is applied to each of
  its result values.
}
\description{
\code{\%using\%} is the infix operator for \code{using}, and it is the
preferred way to use the \code{using} operator.
}
\examples{
(item() \%using\% as.numeric) ("1abc")
}

