% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freedom_functions_2.R
\name{sep.freecalc}
\alias{sep.freecalc}
\title{FreeCalc population sensitivity  for imperfect test}
\usage{
sep.freecalc(N, n, c = 1, se, sp = 1, pstar)
}
\arguments{
\item{N}{population size (scalar)}

\item{n}{sample size (scalar)}

\item{c}{The cut-point number of positives to classify a cluster
as positive, default=1, if positives < c result is negative, 
>= c is positive (scalar)}

\item{se}{test unit sensitivity (scalar)}

\item{sp}{test unit specificity, default=1 (scalar)}

\item{pstar}{design prevalence as a proportion - assumed or target prevalence for 
detection of disease in the population (scalar)}
}
\value{
population-level sensitivity
}
\description{
Calculates population sensitivity for a finite population 
  and allowing for imperfect test sensitivity and specificity, using Freecalc method
}
\examples{
# examples of sep.freecalc
sep.freecalc(150, 30, 2, 0.9, 0.98, 0.1)
sep.freecalc(150, 30, 1, 0.9, 0.98, 0.1)

}
\keyword{methods}
