% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gettersSetters.R
\name{getLayer,RPhosFate-method}
\alias{getLayer,RPhosFate-method}
\alias{getLayer}
\alias{[,RPhosFate,ANY,ANY-method}
\title{Get layer}
\usage{
\S4method{getLayer}{RPhosFate}(x, i, j = NULL)

\S4method{[}{RPhosFate,ANY,ANY}(x, i, j)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}

\item{i}{A character string specifying a layer name. Substance related layers
whose names start with \emph{xx} are treated differently. They have to be
queried by their name (not filename), for example, \code{"xxc"} in combination
with \code{"PP"} in argument \code{j} queries the particulate phosphorus
concentrations in top soils. See subdirectory sections for further
information.}

\item{j}{A character string specifying a substance if applicable.}
}
\value{
A \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} object.
}
\description{
Obtains a project raster layer for further analysis.
}
\section{\emph{Input} subdirectory}{

This directory holds all possible user input raster data (flow obstacles like
roads must be considered during the generation of the flow accumulation layer
and must also be cut out from it in order to be properly respected):
\itemize{
\item \emph{acc_inf:} D-infinity flow accumulations in number of upslope grid
cells required for everything.
\item \emph{CFa:} (R)USLE C-factors required for \code{\link{erosion}}.
\item \emph{cha:} Channel cells required for everything (\code{1}: channel cell, \code{NA}: no
channel cell).
\item \emph{clc:} Clay contents of top soils in \% required for substance
\code{\link{emission}}s.
\item \emph{dem:} Digital elevation model in m a.s.l. (optional).
\item \emph{dir_inf:} D-infinity flow directions in azimuth degrees
measured from north (0 to 360 clockwise) required for
\code{\link{transportPrerequisites}} and substance
\code{\link{transport}}.
\item \emph{fid:} Field IDs (optional).
\item \emph{KFa:} (R)USLE K-factors required for \code{\link{erosion}}.
\item \emph{lue:} Land use classes (optional).
\item \emph{man:} Manning's roughness coefficients required for substance
\code{\link{transport}}.
\item \emph{xxc:} Substance contents of top soils in mg/kg required for substance
\code{\link{emission}}s, for example, \emph{ppc} for PP top soil contents.
\item \emph{rds:} Road cells required for \code{\link{transportPrerequisites}} (\code{0}: road cell
without subsurface drainage, \code{1}: road cell with subsurface drainage, \code{NA}:
no road cell).
\item \emph{RFa:} (R)USLE R-factors required for \code{\link{erosion}}.
\item \emph{slp_inf:} D-infinity slopes in \% required for everything.
\item \emph{wsh:} Watershed (optional).
}
}

\section{\emph{Intermediate} subdirectory}{

This directory holds intermediate calculations:
\itemize{
\item \emph{inl:} Cells representing inlets at roads (storm drains).
\item \emph{LFa:} L-factors.
\item \emph{rip:} Cells representing the riparian zones within channel cells.
\item \emph{SFa:} RUSLE S-factors.
\item \emph{slp_cap:} Capped slopes in \%.
}
}

\section{\emph{Result} subdirectory}{

This directory holds the model results:
\itemize{
\item \emph{ero:} Erosion in t/cell/yr.
\item \emph{xxe:} Substance emissions in kg/cell/yr, for example, \emph{ppe} for PP
emissions.
\item \emph{xxr:} Substance retentions in t/cell/yr (SS) or kg/cell/yr, for example,
\emph{ppr} for PP retentions.
\item \emph{xxt:} Substance transports in t/cell/yr (SS) or kg/cell/yr, for example,
\emph{ppt} for PP transports.
\item \emph{xxt_cld:} Substance cell loads in t/cell/yr (SS) or kg/cell/yr, for
example, \emph{ppt_cld} for PP cell loads.
\item \emph{xxt_ctf:} Substance cell transfers in t/cell/yr (SS) or kg/cell/yr,
for example, \emph{ppt_ctf} for PP transfers.
\item \emph{xxt_inp:} Substance inputs into surface waters in t/cell/yr (SS) or
kg/cell/yr, for example, \emph{ppt_inp} for PP inputs into surface waters.
\item \emph{xxt_out:} Substance outlet loads of subsurface drainages in t/cell/yr
(SS) or kg/cell/yr, for example, \emph{ppt_out} for PP outlet loads.
}
}

\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)
# presupposed method call
x <- firstRun(x, "SS")

getLayer(x, "dir_inf")
getLayer(x, "xxt", "SS")
getLayer(x, "xxe", "PP")}

}
