% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkt_roc.R
\name{rkt_roc}
\alias{rkt_roc}
\alias{print.rkt_roc}
\alias{plot.rkt_roc}
\title{Empirical estimate of the  ROC}
\usage{
rkt_roc(prep, method = 1)

\method{print}{rkt_roc}(x, ...)

\method{plot}{rkt_roc}(x, ...)
}
\arguments{
\item{prep}{A \code{rkt_prep} object.}

\item{method}{A number specifying the type of ROC estimate. Possible values can be viewed with \code{show_methods()}.}

\item{x}{An object of class \code{rkt_roc}.}

\item{...}{Further parameters passed to \code{\link[graphics]{plot}} and \code{\link[graphics]{lines}}}
}
\value{
An object of class \code{rkt_roc}, i.e. a function or a list of two functions (for method = 1).
}
\description{
Calculate the empirical estimate of the ROC from raw sample or aggregated data.
}
\examples{
require(ROCket)

scores <- c(1, 2, 3, 4)
positives <- c(0, 1, 0, 1)
prep <- rkt_prep(scores, positives)

roc1 <- rkt_roc(prep, method = 1)
roc2 <- rkt_roc(prep, method = 2)
roc3 <- rkt_roc(prep, method = 3)

plot(roc1)
plot(roc2)
plot(roc3)
}
