% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkt_prep.R
\name{rkt_prep}
\alias{rkt_prep}
\alias{print.rkt_prep}
\alias{plot.rkt_prep}
\title{ROC points}
\usage{
rkt_prep(scores, positives, negatives = totals - positives, totals = 1)

\method{print}{rkt_prep}(x, ...)

\method{plot}{rkt_prep}(x, ...)
}
\arguments{
\item{scores}{Numeric vector containing the predicted scores.}

\item{positives}{Numeric vector of the same length as \code{scores}. 
The number of positive entities associated with each score. 
If data is not aggregated, a vector of 0's and 1's.}

\item{negatives}{Similar to \code{positives}. Defaults to \code{totals - positives}.}

\item{totals}{How many times each score was predicted. Defaults to 1 (assuming data is not aggregated). 
If any value in \code{positives} is greater than 1 (aggregated data), \code{totals} must be a vector.
Not needed if \code{negatives} is supplied.}

\item{x}{An environment of class \code{rkt_prep} for S3 methods.}

\item{...}{Further parameters.}
}
\value{
An environment of class \code{rkt_prep}.
}
\description{
Calculate the ROC points for all meaningful cutoff values based on predicted scores.
}
\details{
In a situation where many of the predicted scores have the same value it might be easier and faster to use aggregated data.
}
\examples{
require(ROCket)

plot(rkt_prep(1:4, c(0, 1, 0, 1)))
plot(rkt_prep(1:4, c(0, 1000, 0, 1000), totals = 1000))
plot(rkt_prep(1:4, c(100, 200, 300, 400), totals = c(1000, 800, 600, 400)))
}
