% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrices.R
\name{RM_beta}
\alias{RM_beta}
\title{Generate a Hermite \eqn{\beta}-matrix}
\usage{
RM_beta(N, beta)
}
\arguments{
\item{N}{number of dimensions of the square matrix}

\item{beta}{the value of the beta parameter for the beta ensemble}
}
\value{
A random Hermite beta matrix with any integer parameter beta
}
\description{
Hermite-\eqn{\beta} ensemble matrices are matrices with normal entries and beta real number components.
  Using Dumitriu's tridiagonal model, this function is an implementation of the generalized, but not necessarily invariant,
  beta ensembles for \eqn{\beta} > 0.
}
\examples{
# Generate a 3x3 random beta matrix with beta = 4
P <- RM_beta(N = 3, beta = 4)

# Generate a 10x10 random beta matrix with beta = 25
P <- RM_beta(N = 10, beta = 25)

}
