% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{generateScatterplotsAll}
\alias{generateScatterplotsAll}
\title{Wrapper function to generate scatterplots for the specified analytes}
\usage{
generateScatterplotsAll(
  analytes,
  errorListAll,
  colList = NULL,
  nameList,
  tableTCs,
  errorParam = "zzDevAbs",
  withColorCat = NULL,
  titlePart = NULL,
  outputDir = NULL,
  filenamePart = NULL,
  ylim = NULL,
  xlim = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{analytes}{(character) vector specifying for which analytes the scatterplot should be generated}

\item{errorListAll}{(list) containing the overall benchmark results per algorithm}

\item{colList}{(character) vector specifying the colors used for the different algorithms (should correspond to columns of benchmark results)}

\item{nameList}{(character) vector specifying the names used in the legend (should correspond to columns of benchmark results), if NULL, colnames will be used}

\item{tableTCs}{(data frame) containing all test case information}

\item{errorParam}{(character) specifying for which error measure the plot should be generated}

\item{withColorCat}{(character) indicating if plot should be colored according to the pathological fraction ("fractionPathol"), sample size ("N"), or "overlapPatholLeft", "overlapPatholRight"}

\item{titlePart}{(character) specifying the latter part of the title}

\item{outputDir}{(character) specifying a output directory}

\item{filenamePart}{(character) specifying a filename for the plot}

\item{ylim}{(numeric) vector specifying the limits in y-direction for the first granular scale}

\item{xlim}{(numeric) vector specifying the limits in y-direction for the second less detailed scale}

\item{xlab}{(character) specifying x-axis label}

\item{ylab}{(character) specifying y-axis label}

\item{...}{additional arguments passed forward to other functions}
}
\value{
No return value. Instead, a plot is generated.
}
\description{
Wrapper function to generate scatterplots for the specified analytes
}
\author{
Tatjana Ammer \email{tatjana.ammer@roche.com}
}
