% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gspaceGeom.R
\docType{data}
\name{GeomEdgeSpace}
\alias{GeomEdgeSpace}
\title{GeomEdgeSpace: a ggplot2 prototype for GraphSpace-class methods}
\format{
An object of class \code{GeomEdgeSpace} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 5.
}
\usage{
GeomEdgeSpace
}
\description{
`GeomEdgeSpace` is the underlying ggproto object used by 
\code{\link{geom_edgespace}} to draw edge elements in a 2D graph layout, 
whose properties are controlled by aesthetics such as `colour` 
and `linewidth`.

This `geom` is designed for graph/network diagrams, where edge
attributes are often already in their final form (e.g., hex colors).
When used with identity scales, the appearance of edges can be
fully controlled by the input data.
}
\section{Aesthetics}{


`GeomEdgeSpace` understands the following aesthetics:

\itemize{
  \item `x` Starting horizontal position in 
  `npc` \code{\link[grid]{unit}} (required).
  \item `y` Starting vertical position in 
  `npc` \code{\link[grid]{unit}} (required).
  \item `xend` Ending horizontal position in 
  `npc` \code{\link[grid]{unit}} (required).
  \item `yend` Ending vertical position in 
  `npc` \code{\link[grid]{unit}} (required).
  \item `colour` Edge colour.
  \item `linewidth` Edge width, using 'lwd' standard graphics unit 
  (see \code{\link[grid]{gpar}}).
  \item `linetype` Line type, using 'lty' standard graphics unit 
  (see \code{\link[grid]{gpar}}).
  \item `alpha` Transparency applied to the edge colour.
}

These aesthetics follow ggplot2's conventions for segment-like `geoms`.
}

\seealso{
\code{\link{geom_edgespace}}, \code{\link[ggplot2]{geom_segment}}
}
\keyword{datasets}
