% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_regression_diagnostics.R
\name{plot_regression_diagnostics}
\alias{plot_regression_diagnostics}
\title{Plot diagnostics output from calculate_regression_diagnostics as a multi-panel grid (base R)}
\usage{
plot_regression_diagnostics(diagnostics, title = "Regression Diagnostics")
}
\arguments{
\item{diagnostics}{A data.frame as returned by calculate_regression_diagnostics()}

\item{title}{Optional overall title for the entire plot grid (default: "Regression Diagnostics")}
}
\value{
None. Produces plots in the active graphics device.
}
\description{
Creates a static 3x2 grid of base R plots showing regression diagnostics:
\itemize{
\item Normality (Shapiro-Wilk)
\item Linearity (Adjusted R-squared)
\item Heteroscedasticity (Breusch-Pagan)
\item Autocorrelation (Durbin-Watson)
\item Autocorrelation (p-value DW)
}
}
\examples{
plot_regression_diagnostics(
  calculate_regression_diagnostics(
    dataset = data_constraxion,
    period_variable = "period",
    dependent_variable = "price",
    numerical_variables = c("floor_area", "dist_trainstation"),
    categorical_variables = c("dummy_large_city", "neighbourhood_code")
  )
)
}
\author{
Vivek Gajadhar
}
