% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_top_live_games.R
\name{get_top_live_game}
\alias{get_top_live_game}
\title{Top Live Games}
\usage{
get_top_live_game(partner = 1, dota_id = 570, language = "en",
  key = NULL)
}
\arguments{
\item{partner}{The documentation does not specify what this parameter should be but it seems
like numbers from 1-3 return results of live games.}

\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
Returns the top live games by MMR.
}
\details{
A list will be returned that contains three elements. The content, the url and the response
received from the api.

The content element of the list contains a games_list list which contains
information about the top live games. The following information is provided for each game
(Categories are not documented at the time of the release - please check
the Steam API Documentation link below:

\itemize{
  \item \strong{activate_time}
  \item \strong{deactivate_time}
  \item \strong{server_steam_id}
  \item \strong{lobby_id}
  \item \strong{league_id}
  \item \strong{lobby_type}
  \item \strong{game_time}
  \item \strong{delay}
  \item \strong{spectators}
  \item \strong{game_mode}
  \item \strong{average_mmr}
  \item \strong{sort_score}
  \item \strong{last_update_time}
  \item \strong{radiant_lead}
  \item \strong{radiant_score}
  \item \strong{dire_score}
  \item \strong{players}
}
}
\section{Steam API Documentation}{

 \url{https://wiki.teamfortress.com/wiki/WebAPI/GetTopLiveGame}
}
\examples{
\dontrun{
get_top_live_game(partner = 1)
get_top_live_game(partner = 1, language = 'en', key = NULL)
get_top_live_game(partner = 2, language = 'en', key = 'xxxxxxxxxxx')
}

}

