% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{RamerDouglasPeucker}
\alias{RamerDouglasPeucker}
\title{Simplify a curve using the Ramer-Douglas-Peucker algorithm.}
\usage{
RamerDouglasPeucker(x, y, epsilon, keep_index = FALSE)
}
\arguments{
\item{x}{\verb{[numeric]} The \code{x} values of the curve as a vector without \code{NA} values.}

\item{y}{\verb{[numeric]} The \code{y} values of the curve as a vector without \code{NA} values.}

\item{epsilon}{\verb{[positive numeric(1)]} The threshold for filtering outliers from the simplified curve.}

\item{keep_index}{\verb{[logical]} If \code{TRUE}, returns a column called \code{index} with the index locations of points that are kept.}
}
\value{
A \code{data.frame} with \code{x} and \code{y} values of the simplified curve.
}
\description{
Implements the \href{https://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm}{Ramer-Douglas-Peucker algorithm} for reducing the number of points on a curve.
}
\details{
If there are no more than two points it does not make sense to simplify.
In this case the input is returned without further checks of \code{x} and \code{y}.
In particular, the input is not checked for \code{NA} values.
}
\examples{
RDP::RamerDouglasPeucker(x = c(0, 1, 3, 5), y = c(2, 1, 0, 1), epsilon = 0.5)
RDP::RamerDouglasPeucker(x = c(0, 1, 3, 5), y = c(2, 1, 0, 1), epsilon = 0.5, keep_index = TRUE)

}
