% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.types.R
\docType{class}
\name{mdpsType}
\alias{mdpsType}
\title{mdpsType R6 class.}
\format{
An \code{\link[R6]{R6Class}} generator object.
}
\description{
Contains \code{matrix} of melting data points (single data points measured
during amplification).
}
\details{
Columns: \describe{
\item{tmp}{(temperature in degrees Celsius at the time of measurement.
Every point must have unique value.}
\item{fluor}{fluorescence intensity measured without any correction
(including baselining).}}

Inherits: \link{rdmlBaseType}.
}
\section{Initialization}{
 \preformatted{mdpsType$new(fpoints)}

  @section Fields: \describe{
\item{\code{fpoints}}{\link[checkmate]{assertMatrix}. Matrix with amplification data points.}
  }
}

\section{Super class}{
\code{\link[RDML:rdmlBaseType]{RDML::rdmlBaseType}} -> \code{mdpsType}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-mdpsType-new}{\code{mdpsType$new()}}
\item \href{#method-mdpsType-.asXMLnodes}{\code{mdpsType$.asXMLnodes()}}
\item \href{#method-mdpsType-clone}{\code{mdpsType$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="copy"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-copy'><code>RDML::rdmlBaseType$copy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="RDML" data-topic="rdmlBaseType" data-id="print"><a href='../../RDML/html/rdmlBaseType.html#method-rdmlBaseType-print'><code>RDML::rdmlBaseType$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mdpsType-new"></a>}}
\if{latex}{\out{\hypertarget{method-mdpsType-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mdpsType$new(fpoints)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mdpsType-.asXMLnodes"></a>}}
\if{latex}{\out{\hypertarget{method-mdpsType-.asXMLnodes}{}}}
\subsection{Method \code{.asXMLnodes()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mdpsType$.asXMLnodes(node.name)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mdpsType-clone"></a>}}
\if{latex}{\out{\hypertarget{method-mdpsType-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mdpsType$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
