% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_DoseRate.R
\name{model_DoseRate}
\alias{model_DoseRate}
\title{Model dose rate evolution in carbonate-rich samples}
\usage{
model_DoseRate(
  data,
  DR_conv_factors = NULL,
  length_step = 1L,
  max_time = 500L,
  n.MC = 100,
  method_control = list(),
  txtProgressBar = TRUE,
  verbose = TRUE,
  plot = TRUE,
  par_local = TRUE,
  ...
)
}
\arguments{
\item{data}{\link{data.frame} (\strong{required}): input data following the structure given
in the example data set \code{data(Example_Data)}. The input \link{data.frame} should have at least
one row (i.e. values for one sample). For multiple rows the function is automatically re-called.}

\item{DR_conv_factors}{\link{character} (\emph{optional}): applied dose rate conversion factors,
allowed input values are \code{"Carb2007"}, \code{"Adamiec_Aitken_1998"}, \code{"Guerin_et_al_2011"},
\code{"Liritzis_et_al_2013"}. \code{NULL} triggers the default, which is \code{"Carb2007"}}

\item{length_step}{\link{numeric} (with default): step length used for the calculation}

\item{max_time}{\link{numeric} (with default): maximum temporal search range}

\item{n.MC}{\link{numeric} (with default): number of Monte Carlo runs used for the error calculation}

\item{method_control}{(\emph{optional}): additional arguments that can be provided to the control the
the modelling. See details for further information.}

\item{txtProgressBar}{\link{logical} (with default): enables/disables the \code{txtProgressBar} for the MC runs}

\item{verbose}{\link{logical} (with default): enables/disables verbose mode}

\item{plot}{\link{logical} (with default): enables/disables plot output}

\item{par_local}{\link{logical} (with default): enables/disable local par settings, If set
to \code{FALSE} all global par settings are accepted.}

\item{...}{further arguments passed to the underlying plot functions, see also details for further information. Supported standard arguments are \code{mfrow}, \code{xlim}, \code{xlab}.}
}
\value{
The function returns numerical and graphical output

-----------------------------------\cr
\verb{[ NUMERICAL OUTPUT ]}\cr
-----------------------------------\cr
\itemize{
\item A \link{data.frame} which is the combination of the input and values calculated by this function.
}

-----------------------------------\cr
\verb{[ GRAPHICAL OUTPUT ]}\cr
-----------------------------------\cr

\strong{Upper plot:} Dose rate evolution over time backwards. The solid black line is the calculation
output, the grey shaded area indicates the 2-sigma error margins. The dashed blue line is an indicator
of the quality of the error estimations based on Monte Carlo (MC) runs.The closer it follows the
black line, the more reliable are the given error margins. \cr

\strong{Lower plot:} Totally absorbed dose over time. The plot is an representation of the 'new'
age based on the carbonate modelling.
}
\description{
This function models the dose rate evolution in carbonate enrich environments. For the
calculation internal functions are called.
}
\details{
This function is the starting point for the dose rate modelling for carbonate enrich
environments. It provides basically the same functionality as the original version of \code{'Carb'}, i.e.
you should be also aware of the limitations of this modelling approach. In particular: The model
assumes a linear carbonate mass increase due to post-depositional processes. Please read the
references cited blow.\cr

\strong{Uncertainty estimation}

For estimating the uncertainties, Monte-Carlo (MC) simulation runs are used. For very
small values (close to 0) this can, however, lead to edge effects (similar in \code{'Carb'}) since
values below 0 are set to 0.
}
\section{Function version}{
 0.2.1
}

\examples{
##load example data
data("Example_Data", envir = environment())

##run the function for one sample from
##the dataset
model_DoseRate(
data = Example_Data[14,],
n.MC = 2,
txtProgressBar = FALSE
)


} 

\section{How to cite}{
Kreutzer, S., 2025. model_DoseRate(): Model dose rate evolution in carbonate-rich samples. Function version 0.2.1. In: Kreutzer, S., Nathan, R.P., Mauz, B., 2025. RCarb: Dose Rate Modelling of Carbonate-Rich Samples . R package version 0.1.7. https://r-lum.github.io/RCarb/
}

\references{
Mauz, B., Hoffmann, D., 2014. What to do when carbonate replaced water: Carb, the model for estimating the
dose rate of carbonate-rich samples. Ancient TL 32, 24-32. \doi{10.26034/la.atl.2014.481}

Nathan, R.P., Mauz, B., 2008. On the dose-rate estimate of carbonate-rich sediments for trapped charge dating.
Radiation Measurements 43, 14-25. \doi{10.1016/j.radmeas.2007.12.012} \cr

\strong{Further reading}

Nathan, R.P., 2010. Numerical modelling of environmental dose rate and its application to trapped-charge dating.
DPhil thesis, St Hugh's College, Oxford. \url{https://ora.ox.ac.uk/objects/ora:6421}

Zimmerman, D.W., 1971. Thermoluminescent dating using fine grains from pottery.
Archaeometry 13, 29–52.\doi{10.1111/j.1475-4754.1971.tb00028.x}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany); based
on 'MATLAB' code given in file Carb_2007a.m of \emph{Carb}
}
\keyword{dplot}
\keyword{manip}
