% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est-c.r
\name{mn.regu.path}
\alias{mn.regu.path}
\title{Model-assisted inference for population means along a regularization path}
\usage{
mn.regu.path(fold, nrho = NULL, rho.seq = NULL, y, tr, x, ploss = "cal",
  yloss = "gaus", off = 0, ...)
}
\arguments{
\item{fold}{A vector of length 2, with the second component giving the fold number for cross validation in outcome regression. The first component is not used.}

\item{nrho}{A vector of length 2 giving the number of tuning parameters in a regularization path for PS estimation and that in cross validation for OR.}

\item{rho.seq}{A list of two vectors giving the tuning parameters for propensity score estimation (first vector) and outcome regression (second vector).}

\item{y}{An \eqn{n} x \eqn{1} vector of outcomes with missing data.}

\item{tr}{An \eqn{n} x \eqn{1} vector of non-missing indicators (=1 if \code{y} is observed or 0 if \code{y} is missing).}

\item{x}{An \eqn{n} x \eqn{p} matix of covariates, used in both propensity score and outcome regression models.}

\item{ploss}{A loss function used in propensity score estimation (either "ml" or "cal").}

\item{yloss}{A loss function used in outcome regression (either "gaus" for continuous outcomes or "ml" for binary outcomes).}

\item{off}{An offset value (e.g., the true value in simulations) used to calculate the z-statistic from augmented IPW estimation.}

\item{...}{Additional arguments to \code{\link{glm.regu.cv}} and \code{\link{glm.regu.path}}.}
}
\value{
\item{ps}{A list containing the results from fitting the propensity score model by \code{\link{glm.regu.path}}.}
\item{fp}{The matrix of fitted propensity scores, column by column, along the PS regularization path.}
\item{or}{A list of objects, each giving the results from fitting the outcome regression model by \code{\link{glm.regu.cv}} for a PS tuning parameter.}
\item{fo}{The matrix of fitted values from outcome regression based on cross validation, column by column, along the PS regularization path.}
\item{est}{A list containing the results from augmented IPW estimation by \code{\link{mn.aipw}}.}
\item{rho}{A vector of tuning parameters leading to converged results in propensity score estimation.}
}
\description{
This function implements model-assisted inference for population means with missing data,
using regularized calibrated estimation along a regularization path for propensity score (PS) estimation 
while based on cross validation for outcome regression (OR).
}
\details{
See \strong{Details} for \code{\link{mn.regu.cv}}.
}
\examples{
\donttest{
data(simu.data)
n <- dim(simu.data)[1]
p <- dim(simu.data)[2]-2

y <- simu.data[,1]
tr <- simu.data[,2]
x <- simu.data[,2+1:p]
x <- scale(x)

# missing data
y[tr==0] <- NA

mn.path.rcal <- mn.regu.path(fold=5*c(0,1), nrho=(1+10)*c(1,1), y=y, tr=tr, x=x, 
                             ploss="cal", yloss="gaus")
mn.path.rcal$est
}

}
\references{
Tan, Z. (2020a) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, \emph{Biometrika}, 107, 137–158.

Tan, Z. (2020b) Model-assisted inference for treatment effects using regularized calibrated estimation with high-dimensional data, \emph{Annals of Statistics}, 48, 811–837.
}
