#' Visualize the effect of varying a stacks parameter on the number of SNPs retained
#'
#' This function takes the list of dataframes output by optimize_m(), optimize_M(), or optimize_n() as input.
#' The function then uses ggplot2 to visualize the effect of the given stacks on the number of SNPs retained.
#'
#' @param output A list containing 5 dataframes generated by optimize_m()
#' @param stacks_param A character string indicating the stacks parameter iterated over
#' @return A plot showing the number of SNPs retained at each given parameter value
#' @examples
#' vis_snps(output=
#' readRDS(system.file("extdata","optimize.m.output.RDS",package="RADstackshelpR",mustWork=TRUE)),
#'          stacks_param = "m")
#' @export
vis_snps <- function(output=NULL, stacks_param=NULL){
#bind these variables to the function
snps <- var <- snps.80 <- NULL

  #isolate SNP df
  snp.df<-output$snp
  snp.df$var<-as.factor(snp.df$var)
  snp.df$snps<-as.numeric(as.character(snp.df$snps))

  #isolate SNP R80 df
  snp.R80.df<-output$snp.R80
  snp.R80.df$var<-as.factor(snp.R80.df$var)
  snp.R80.df$snps.80<-as.numeric(as.character(snp.R80.df$snps.80))

  cat("Visualize how different values of", stacks_param, "affect number of SNPs retained.
Density plot shows the distribution of the number of SNPs retained in each sample,
while the asterisk denotes the total number of SNPs retained at an 80% completeness cutoff.", "\n")
  return(
    ggplot2::ggplot(snp.df, ggplot2::aes(x = snps, y = var)) +
      ggridges::geom_density_ridges(jittered_points = FALSE, alpha = .5) +
      ggplot2::geom_point(snp.R80.df, mapping=ggplot2::aes(x=snps.80, y=var), pch=8, cex=3)+
      ggplot2::theme_classic() +
      ggplot2::labs(x = "SNPs retained", y = paste(stacks_param, "value")) +
      ggplot2::theme(legend.position = "none")
  )
#close function
}
