% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cdbAddDocS.R
\name{cdbAddDocS}
\alias{cdbAddDocS}
\title{This function adds multiple database documents with one request}
\usage{
cdbAddDocS(cdb)
}
\arguments{
\item{cdb}{\code{cdb$dataList} has to be a list of lists,
\code{cdb$DBName}, \code{cdb$serverName} is needed.}
}
\value{
\item{cdb}{The couchdb response is stored in \code{cdb$res} }
}
\description{
This is done via the _bulk_docs API provided by
an already existing database.
}
\details{
The _bulk_docs endpoint requires that \code{cdb$dataList} resolves
to an json array. This is reached with e.g.
\code{cdb$dataList <- list(list(...),list(...),...)}.
Furthermore, _bulk_docs requires the documents to be wrapped in a key
named \code{docs:[...]}; this is done by \code{cdbAddDocS()} if
\code{cdb$dataList} is a list of lists. The user dont need to care.

At the moment the resulting \code{_rev} and  \code{_id} will be not
written back to the \code{cdb$dataList}. This means that a second
call of  \code{cdbAddDocS()} generates new Documents.
}
\examples{
\dontrun{
ccc               <- cdbIni()
# I assume a database at localhost:5984 already exists
ccc$DBName        <- "r4couchdb_db"
docs <- list()
for(i in 1:10){
 docs[[i]] <- list(normalDistRand =  rnorm(20))
}
# docs is noe a list of 10 lists
ccc$dataList <- docs
# generating 10 database documents
cccAddDocS(ccc)$res
}
}
\author{
parisni, wactbprot
}
\seealso{
\code{cdbAddDoc()}
}
\keyword{misc}

