% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_param.R
\name{track_param}
\alias{track_param}
\title{Print track parameters}
\usage{
track_param(data)
}
\arguments{
\item{data}{A \code{track} R object, which is a list consisting of two elements:
\itemize{
\item \strong{\code{Trajectories}}: A list of interpolated trajectories, where each trajectory is a series of midpoints between consecutive footprints.
\item \strong{\code{Footprints}}: A list of data frames containing footprint coordinates, metadata (e.g., image reference, ID), and a marker indicating whether the footprint is actual or inferred.
}}
}
\value{
A list of lists, where each sublist contains the computed parameters for a corresponding track.
The parameters included are:
\itemize{
\item \code{Turning_angles}: A vector of turning angles for the track (in degrees).
\item \code{Mean_turning_angle}: The mean of the turning angles (in degrees).
\item \code{Standard_deviation_turning_angle}: The standard deviation of the turning angles (in degrees).
\item \code{Distance}: The total distance covered by the track (in meters).
\item \code{Length}: The length of the track  (in meters).
\item \code{Step_lengths}: A vector of step lengths for the track  (in meters).
\item \code{Mean_step_length}: The mean of the step lengths  (in meters).
\item \code{Standard_deviation_step_length}: The standard deviation of the step lengths  (in meters).
\item \code{Sinuosity}: The sinuosity of the track (dimensionless).
\item \code{Straightness}: The straightness of the track (dimensionless).
}

The reference direction, or 0 degrees, is considered to be along the positive x-axis. This means that angles are measured counterclockwise from the positive x-axis, with 0 degrees (or 0 degrees) pointing directly along this axis. For a detailed explanation and appropriate methods for analyzing circular data, refer to Batschelet (1981).

Sinuosity is calculated according to Benhamou (2004), as defined in equation 8.
The formula used here is a refined version of the sinuosity index presented by Bovet & Benhamou (1988),
which is applicable to a broader range of turning angle distributions and does not require a constant step length.

The sinuosity is computed using the formula:
\deqn{S = 2 \left[ p \left( \frac{1 + c}{1 - c} + b^2 \right) \right]^{-0.5}}
where:
\item{p}{is the mean step length (in meters),}
\item{c}{is the mean cosine of turning angles (in radians), and}
\item{b}{is the coefficient of variation of the step length (in meters).}

The straightness index is defined as the ratio D/L, where:
\item{D}{is the beeline distance between the first and last points in the trajectory (in meters), and}
\item{L}{is the total path length traveled (in meters).}

Straightness index is based on the method described by Batschelet (1981). According to Benhamou (2004),
the straightness index serves as a reliable measure of the efficiency of a directed walk. However, it is not suitable
for random trajectories, as the index for a random walk tends towards zero with increasing steps. Thus, it is recommended
to use this measure to compare the tortuosity of random walks only if they consist of a similar number of steps.
}
\description{
\code{track_param()} is a function to compute and print various parameters of tracks from a list of track data.
}
\details{
This function calculates various movement parameters for each track in the provided data.
It uses the following helper functions from the \pkg{trajr} (Animal Trajectory Analysis) package:
\itemize{
\item \code{TrajAngles()}: Calculates the turning angles of the track.
\item \code{TrajDistance()}: Calculates the total distance covered by the track.
\item \code{TrajLength()}: Calculates the length of the track.
\item \code{TrajStepLengths()}: Calculates the step lengths of the track.
\item \code{TrajSinuosity2()}: Calculates the sinuosity of the track.
\item \code{TrajStraightness()}: Calculates the straightness of the track.
}
}
\section{Logo}{

\if{html}{\figure{Logo.png}{options: width=30\%}}
}

\examples{
# Example 1:
track_param(PaluxyRiver)

# Example 2:
track_param(MountTom)

}
\references{
Batschelet, E. (1981). Circular statistics in biology. Academic press, 111 Fifth Ave., New York, NY 10003, 1981, 388.

Benhamou, S. (2004). How to reliably estimate the tortuosity of an animal's path:: straightness, sinuosity, or fractal dimension?. Journal of theoretical biology, 229(2), 209-220.

Bovet, P., & Benhamou, S. (1988). Spatial analysis of animals' movements using a correlated random walk model. Journal of theoretical biology, 131(4), 419-433.
}
\seealso{
\code{\link{tps_to_track}}
}
\author{
Humberto G. Ferrón

humberto.ferron@uv.es

Macroevolution and Functional Morphology Research Group (www.macrofun.es)

Cavanilles Institute of Biodiversity and Evolutionary Biology

Calle Catedrático José Beltrán Martínez, nº 2

46980 Paterna - Valencia - Spain

Phone: +34 (9635) 44477
}
