% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Shout.R
\name{ShoutFD}
\alias{ShoutFD}
\title{Shout option valuation via finite differences (FD) method}
\usage{
ShoutFD(o = OptPx(Opt(Style = "Shout")), N = 100, M = 20, Smin = 0,
  Smax = 100)
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{N}{The number of equally spaced intervals. Default is 100.}

\item{M}{The number of equally spaced stock price. Default is 20.}

\item{Smin}{similar to Smax}

\item{Smax}{A stock price sufficiently high that, when it is reached, the put option has virtually no value.
The level of Smax should be chosen in such a way that one of these equally spaced stock prices is the current stock price.}
}
\value{
A list of class \code{OptPx}, including
option pricing parameters \code{N}, \code{M}, \code{Smin}, and \code{Smax},
as well as the computed option price \code{PxFD}.
}
\description{
Shout option valuation via finite differences (FD) method
}
\details{
A shout option is a European option where the holder can 'shout' to the writer at one time during its life.
At the end of the life of the option, the option holder receives either the usual payoff from a European option
or the intrinsic value at the time of the shout, whichever is greater.
An explicit finite difference method (Page 482 in Hull's book) is used here to price the shout put option.
Similar to pricing American options, the value of the option is consolidated at each node of the grid
to see if shouting would be optimal.
The corresponding shout call option is priced using the Put-Call-Parity in the finite difference method .
}
\examples{
(o = ShoutFD(OptPx(Opt(Right="C", Style="Shout"))))$PxFD

 o = OptPx(Opt(Right="C", Style="Shout"))
 (o = ShoutFD(o, N=10))$PxFD # very differnt result for N=10

 (o = ShoutFD(OptPx(Opt(Right="P", Style="Shout"))))$PxFD

 o = Opt(Right='P', S0=100, K=110, ttm=0.5, Style='Shout')
 o = OptPx(o, vol=0.2, r=0.05, q=0.04)
 (o = ShoutFD(o,N=100,Smax=200))$PxFD

 o = Opt(Right="C", S0=110, K=100, ttm=0.5, Style="Shout")
 o = OptPx(o, vol=0.2, r=0.05, q=0.04)
 (o = ShoutFD(o,N=100,Smax=200))$PxFD
}
\author{
Xinnan Lu, Department of Statistics, Rice University, 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html} pp.609.
}

