\name{pcr}
\alias{pcr}

\title{
Propensity-Constrained Randomization
}

\description{
Performs propensity-contstrained randomization on a given data set with measured covariates on all units.
}
\usage{
pcr(x, nTreat, M, m)
}
\arguments{
  \item{x}{Data frame of covariates.}
  \item{nTreat}{Number of units to be treated.}
  \item{M}{Number of candidate permutations to create.}
  \item{m}{Number of permutations to keep.}
}
\details{
Given the parameters, \code{pcr} generates \code{M} unique permutations by calling \code{\link{genPerms}}.  For each permutation, the empirical propensity scores are computed and the variance returned by \code{\link{getVar}}.  Finally, the \code{m} permutations with the smallest propensity score variance are found.  The \code{m} permutations returned in \code{best} can then be used to perform randomization and randomization inference.  We suggest \code{M >= 10000} and \code{m/M <= 0.10}.
}
\value{
  \item{treatments}{The (approximately) \code{M} permutations generated by \code{\link{genPerms}}.}
  \item{variance}{A vector of the propensity score variances for all \code{M} permutations in \code{treatments}.}
  \item{cutoff}{The calculated \code{m/M} quantile of propensity score variances.}
  \item{best}{The column indices of the permutations in \code{treatments} with propensity score variance below \code{cutoff}.}
}

\references{
Loux, T.M. (2015) Randomization, matching, and propensity scores in the design and analysis of experimental studies with known covariates. Statistics in Medicine. 34(4), 558-570. DOI: 10.1002/sim.6361
}

\author{
Travis Loux
}

\examples{
# 1:1 allocation, M small
dat1 = data.frame(x1=rnorm(50),
                  x2=rnorm(50),
                  x3=sample(c('a','b','c'), size=50, replace=TRUE))
trial1 = pcr(x=dat1, nTreat=25, M=500, m=50)

# 1:1 allocation, M large
dat2 = data.frame(x1=rnorm(10),
                  x2=rnorm(10),
                  x3=sample(c('a','b','c'), size=10, replace=TRUE))
trial2 = pcr(x=dat2, nTreat=5, M=200, m=20)

# non-1:1 allocation, M small
dat3 = data.frame(x1=rnorm(50),
                  x2=rnorm(50),
                  x3=sample(c('a','b','c'), size=50, replace=TRUE))
trial3 = pcr(x=dat3, nTreat=35, M=200, m=20)

# non-1:1 allocation, M large
dat4 = data.frame(x1=rnorm(10),
                  x2=rnorm(10),
                  x3=sample(c('a','b','c'), size=10, replace=TRUE))
trial4 = pcr(x=dat4, nTreat=6, M=300, m=30)
}

\keyword{ design }
\keyword{ multivariate }
