% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileGLMM_predict.R
\name{profileGLMM_predict}
\alias{profileGLMM_predict}
\title{Prediction of cluster memberships and outcomes}
\usage{
profileGLMM_predict(post_Obj, XFE, XLat, UCont, UCat)
}
\arguments{
\item{post_Obj}{The post-processed output from the \code{profileGLMM_postProcess} function. Must contain \code{pop} for population constant parameters and optionally \code{clust} for cluster-specific parameters.}

\item{XFE}{A numeric matrix of fixed effects covariates for the prediction data.}

\item{XLat}{A numeric matrix of latent effect covariates. This matrix is used for the interaction term with the predicted cluster membership.}

\item{UCont}{A numeric matrix or vector of continuous profile variables (used for predicting cluster membership). Set to \code{NULL} if no continuous variables were used in the model.}

\item{UCat}{A numeric matrix or vector of categorical profile variables (used for predicting cluster membership). Set to \code{NULL} if no categorical variables were used in the model.}
}
\value{
A list with the following elements:
\describe{
  \item{\code{FE}:}{ A numeric vector of the predicted fixed effects contribution to the outcome.}
  \item{\code{Y}:}{ A numeric vector of the total predicted outcome (FE + Lat).}
  \item{\code{classPred}:}{ A factor vector of the predicted cluster membership for each observation. \code{NULL} if no representative clustering was provided in \code{post_Obj}.}
  \item{\code{Int}:}{ A numeric vector of the predicted latent effect contribution to the outcome. \code{NULL} if no representative clustering was provided.}
}
}
\description{
This function uses the results of the post-processed Profile GLMM MCMC chain to predict cluster memberships and outcomes for new or existing data. It first calculates the fixed effect (FE) contribution and then, if a representative clustering is available in \code{post_Obj}, computes the predicted cluster membership and the corresponding latent effect (Lat) contribution to the outcome.
}
\examples{
# Load post_Obj, the result of profileGLMM_postProcess()
data("examp")
post_Obj = examp$post_Obj
# Load dataProfile, the result of profileGLMM_preProcess()
dataProfile = examp$dataProfile
pred_Obj = profileGLMM_predict(post_Obj,
                               dataProfile$d$XFE,
                               dataProfile$d$XLat,
                               dataProfile$d$UCont,
                               dataProfile$d$UCat)
}
