% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/get_recent_personal_explanations_votes_specific_member.R
\name{get_recent_personal_explanations_votes_specific_member}
\alias{get_recent_personal_explanations_votes_specific_member}
\title{Get Recent Personal Explanation Votes by a Specific Member}
\usage{
get_recent_personal_explanations_votes_specific_member(
  member_id,
  congress,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{member_id}{The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{congress}{110-116}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent personal explanations by a specific member in the specified Congress, and supports paginated requests using multiples of 20.
}
\description{
Lawmakers, mostly in the House but also in the Senate, can make personal explanations for missed or mistaken votes in the Congressional Record. To get recent personal explanations by a specific member that are parsed to individual votes and have an additional category attribute describing the general reason for the absence or incorrect vote, use the following function. HTTP Request: GET https://api.propublica.org/congress/v1/members/{member_id}/explanations/{congress}/votes.json
}
\examples{
\dontrun{
get_recent_personal_explanations_votes_specific_member('S001193', 115)
}
}
