% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_house_senate_floor_actions_by_date.R
\name{get_house_senate_floor_actions_by_date}
\alias{get_house_senate_floor_actions_by_date}
\title{Get House and Senate Floor Actions by Date}
\usage{
get_house_senate_floor_actions_by_date(
  chamber,
  year,
  month,
  day,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{chamber}{house or senate}

\item{year}{YYYY format}

\item{month}{MM format}

\item{day}{DD format}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves the 20 most recent results for that date and supports pagination using multiples of 20.
}
\description{
To get the latest actions from the House or Senate floor, use the following function. HTTP Request: GET hhttps://api.propublica.org/congress/v1/{chamber}/floor_updates/{year}/{month}/{day}.json
}
\examples{
\dontrun{
get_house_senate_floor_actions_by_date('senate', 2017, '05', '02')
}
}
