#' A real data set on sold rice, sugar and milk products
#'
#' A collection of scanner data on the sale of rice, sugar and milk products in one of Polish supermarkets in the period from December 2023 to January 2025
#' @format A data frame with 9 columns and 8090 rows. The used variables are as follows:
#'
#' \code{time} - Dates of transactions (Year-Month-Day)
#'
#' \code{prices} - Prices of sold products [PLN]
#'
#' \code{quantities} - Quantities of sold products [items]
#'
#' \code{retID} - Unique codes identifying outlets/retailer sale points (data set contains 4 different retIDs)
#'
#' \code{description} - Descriptions (labels) of sold products (data set contains 152 different descriptions)
#'
#' \code{retailer_code} - Retailer codes for product definition (134 retailer codes)
#'
#' \code{EAN_code} - EAN codes (bar codes) for product definition (138 EAN codes)
#'
#' \code{category} - Product categories at the 6-digit COICOP level (4 categories)
#'
#' \code{subcategory} - Product subcategories from 7-digit COICOP level (11 subcategories)
#'
#' @docType data
#'
"dataRSM"