% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreprocessMatrix.R
\name{PreprocessMatrix}
\alias{PreprocessMatrix}
\title{Preprocess Matrix}
\usage{
PreprocessMatrix(
  input_file,
  output_folder = NULL,
  prefix = NULL,
  max_bound = 10,
  zero_perturb = FALSE,
  threads = 1,
  verbose = FALSE
)
}
\arguments{
\item{input_file}{Input comma separated file for the jacobian matrix.}

\item{output_folder}{Optional output folder to save python objects to disk. 
A number of files will be created in the form ‘output_folder/<prefix>_*.npy’.
Default is NULL.}

\item{prefix}{Prefix of output files, if you so choose.}

\item{max_bound}{some of the matrices are unbounded stable towards one end, this 
is the limit the user imposes. Default: 10}

\item{zero_perturb}{Flag to indicate you want to perturb the zero entries. 
Default: FALSE}

\item{threads}{Number of threads to use. Default: 1}

\item{verbose}{Default: FALSE}
}
\value{
A list of with the following objects: matrix_size, column_names, row_names,
non_zero, num_switch_functions, asymptotic_stability_start,
asymptotic_stability_end, num_switch_funcs_r
}
\description{
This script pre-processes a matrix by figuring out what the intervals of asymptotic
stability are, as well as finding which perturbation values lead to a sign switch.
}
\examples{
\dontrun{
infile <- system.file("extdata", "Modules", "IGP.csv", 
    package = "PressPurt") 
PreProsMatrix <- PreprocessMatrix(input_file = infile, 
    output_folder = NULL, max_bound = 10, threads = 2)
}
}
