% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr.R
\name{hrPc}
\alias{hrPc}
\title{Empirical UMP beta central rejection level}
\usage{
hrPc(w, alpha = 0.05, M = 2, nsim = 1e+05)
}
\arguments{
\item{w}{numeric between 0 and 1}

\item{alpha}{numeric between 0 and 1}

\item{M}{integer sample size greater than 0}

\item{nsim}{integer, the number of simulated null cases generated}
}
\value{
A numeric between 0 and 1.
}
\description{
Uses simulation to estimate the central rejection
level for the UMP pooled p-value of a restricted beta family
}
\details{
The central rejection level is the maximum p-value
shared among all tests which still results in rejection of the
null using a pooled p-value.

To test the null hypotheses that all p-values are uniform
against a restricted beta family 0 < a <= 1 <= b, the most
powerful pooled p-value linearly combines upper and lower tail
probabilities of the chi-squared distribution with two degrees
of freedom with weights w and (1 - w) where w = (1 - a)/(b - a).

This function estimates the central rejection level empirically
by simulating a specified number of null cases to give an empirical
pooled p-value for the rejection level alpha.
}
\examples{
hrPc(w = 0.5, alpha = 0.05, M = 10)
hrPc(w = 0.5, alpha = 0.05, M = 20)
}
\author{
Chris Salahub
}
