% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{make.ShesisPlus.input}
\alias{make.ShesisPlus.input}
\title{convert PolyHaplotyper marker data to ShesisPlus format}
\usage{
make.ShesisPlus.input(mrkDosage, indiv=NULL, markers,
ploidy, phenotype=0, fname="")
}
\arguments{
\item{mrkDosage}{matrix or data.frame of allele dosages; same as input for
inferHaplotypes. Markers are in rows, individuals in columns, each cell has
a marker dosage. All marker dosages must be in 0:ploidy or NA}

\item{indiv}{the names of the individuals to include in the ShesisPlus
input data. Default NULL includes all individuals}

\item{markers}{character vector with the names of the markers in the
haploblock; all must occur in mrkDosage}

\item{ploidy}{single integer: the ploidy level}

\item{phenotype}{vector with the phenotypes of all individuals, in order
of the columns of dosmat; default 0}

\item{fname}{filename of the output file: this will contain the data
in the ShesisPlus format (the saved data.frame is also the return value).
If "" (default) no file is written}
}
\value{
a data.frame in the described ShesisPlus input format
}
\description{
convert PolyHaplotyper marker data (input) to ShesisPlus
format for a single haploblock.
}
\details{
ShesisPlus needs the data formatted as: 1 column with names of
individuals, 1 column with the phenotypes (with missing values represented
as "NA"), and for each of the selected markers <ploidy> columns,
with the (unphased) marker alleles. Here we use only biallelic markers;
their alleles are indicated by 1 and 2 for the ref and alt allele,
and 0 for missing data. \cr
The contents of file fname can be pasted into the input data box of
the ShesisPlus web interface at http://shesisplus.bio-x.cn/SHEsis.html
}
\examples{
data(PolyHaplotyper_small)
SSPin <- make.ShesisPlus.input(mrkDosage=phdos, markers=phblocks[[1]],
                              ploidy=6)
SSPin[1:6,1:8]
}
