% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{checkmrkDosage}
\alias{checkmrkDosage}
\title{check a marker dosages matrix or data.frame}
\usage{
checkmrkDosage(mrkDosage, ploidy, indiv=NULL, markers=NULL,
generateMarkernames=TRUE)
}
\arguments{
\item{mrkDosage}{matrix or data.frame. Markers are in rows, individuals in
columns, each cell has a marker dosage. If mrkDosage is a matrix,
the colnames are the individual names and the rownames are the marker names.
If mrkDosage is a data.frame and the name of the first column starts with
"marker" (upper/lowercase not relevant) the contents of this column are used
as marker names, else the rownames are used as marker names. The (other)
column names are the individual names.
All marker dosages must be in 0:ploidy or NA.}

\item{ploidy}{an integer value; all dosages are checked to be in 0:ploidy or NA}

\item{indiv}{NULL (default) or a character vector with names of individuals
to be selected. If NULL, all individuals are selected}

\item{markers}{NULL (default) or a character vector with names of markers
to be selected. If NULL, all markers are selected.}

\item{generateMarkernames}{if TRUE (default) and mrkDosage has no markernames
specified, markernames are generated automatically. Markernames
must be either present or be generated, and none may be missing.}
}
\value{
a matrix with the selected columns in the order of indiv and the
selected rows in order of markers (or all columns or rows in the original
order if indiv or markers are not specified), with
names of individuals as column names, marker names as row names
}
\description{
check a marker dosages matrix or data.frame, select columns and rows,
convert to matrix
}
\details{
This function is called by inferHaplotypes and by mergeReplicates, so
normally there is no need for the user to call this function directly.
}
\examples{
mrkdos <- data.frame(
 marker=paste0("mrk", 1:3),
 indiv1=c(1, 2, 2),
 indiv2=c(4, 0, 0),
 indiv3=c(3, 0, 2))
# use all rows and columns:
checkmrkDosage(mrkDosage=mrkdos, ploidy=4)
# use only first and last row and column and change the order:
checkmrkDosage(mrkDosage=mrkdos, ploidy=4, indiv=c("indiv3", "indiv1"),
              markers=c("mrk3", "mrk1"))
}
