% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{build_ahccompletelist}
\alias{build_ahccompletelist}
\title{generate a list with all haplotype combinations}
\usage{
build_ahccompletelist(ploidy, maxmrk, savesec=1800, printsec=300,
overwrite, shorten=FALSE)
}
\arguments{
\item{ploidy}{ploidy; may be even or odd, but inferHaplotypes only works
with even ploidy if FS families are present, so building an ahccompletelist
for odd ploidy is probably not useful}

\item{maxmrk}{the list will countain all haplotype combinations for
haploblocks of 1...maxmrk markers}

\item{savesec}{default 1800: number of seconds between successive saves of
the intermediate results}

\item{printsec}{default 300: number of seconds between printout of
the current set of haplotypes. NA or 0 suppresses printing.}

\item{overwrite}{the new file ahccompletelist_<ploidy>x.RData is written in
the working directory. If a file with that name already exists and would be
changed, this is aborted and the old file maintained if overwrite is FALSE}

\item{shorten}{if file ahccompletelist_<ploidy>x.RData already exists and
covers haploblocks of lengths longer than maxmrk,
this file is left unchanged if shorten is FALSE (default), but is shortened
to maxmrk if shorten is TRUE}
}
\value{
NULL (invisible); the actual result is a file in the working directory
named ahccompletelist_<ploidy>x.RData
}
\description{
generate a list which contains for each marker dosage combination
at a given ploidy all matching haplotype combinations
}
\details{
An ahccompletelist reduces the processing time of inferHaplotypes enormously
but takes a long time to build. This should therefore be done when
PolyHaplotyper will be used multiple times.\cr
If an ahccompletelist file already exists in the working directory, this file is
used as starting point; if maxmrk is larger than the length of the existing
list only the additional items are calculated.\cr
If this function crashes (due to exceeding the memory limits of the computer
or of R) the file ahccompletelist_<ploidy>x.RData in the working directory
contains an intact version of the ahccompletelist for the last finished
marker count. Also, the temporary file
"buildAHCcompletelist_<datetime>"_"<nmrk>.RData" contains a part of the
list item for the number of markers being calculated at that moment.\cr
Note that this function takes lots of time and memory already for
ploidy 4 / maxmrk 7 and ploidy 6 / maxmrk 5, and is not practicable above
ploidy 4 / maxmrk 8, ploidy 6 / maxmrk 6, ploidy 8 / maxmrk 5. Also, the
files are large and take up considerable memory, and most of the size is
used for the largest haploblock size. Therefore maxmrk should
not be taken larger than necessary.
}
\examples{
\donttest{
# this example will create a file ahccompletelist_4x.RData
# in the working directory, for ploidy=4x and 1 - 4 markers:
build_ahccompletelist(ploidy=4, maxmrk=4, overwrite=FALSE)
}
}
