% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tScales.R
\name{tScales}
\alias{tScales}
\title{Compute the T-scales of a protein sequence}
\usage{
tScales(seq)
}
\arguments{
\item{seq}{An amino-acids sequence}
}
\value{
The computed average of T-scales of all the amino acids in the corresponding peptide sequence.
}
\description{
T-scales are based on 67 common topological descriptors of 135 amino acids. These topological descriptors are based on the connectivity table of amino acids alone, and to not explicitly consider 3D properties of each structure.
}
\examples{
tScales(seq = "QWGRRCCGWGPGRRYCVRWC")
# [[1]]
# T1      T2      T3      T4      T5
# -3.2700 -0.0035 -0.3855 -0.1475  0.7585
}
\references{
Tian F, Zhou P, Li Z: T-scale as a novel vector of topological descriptors for amino acids and its application in QSARs of peptides. J Mol Struct. 2007, 830: 106-115. 10.1016/j.molstruc.2006.07.004.
}
