% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omics_network.R
\name{cutoff,omics_network-method}
\alias{cutoff,omics_network-method}
\alias{cutoff}
\alias{cutoff-methods}
\title{Choose the best cutoff}
\usage{
\S4method{cutoff}{omics_network}(Omega, sequence = NULL, x_min = 0)
}
\arguments{
\item{Omega}{a omics_network object}

\item{sequence}{a vector corresponding to the sequence of cutoffs that will be tested.}

\item{x_min}{an integer ; only values over x_min are further retained for performing the test.}
}
\value{
A list containing two objects : \item{p.value}{the p values
corresponding to the sequence of cutoff} \item{p.value.inter}{the smoothed p
value vector, using the loess function}
}
\description{
Allows estimating the best cutoff. For a sequence of cutoff, the p value
corresponding to each cutoff value of the sequence. Mainly recommended for
single time cascade networks. To achieve more sparsity in other settings,
please use a fiiting function based on the stability selection or
selectboost algorithms.
}
\examples{

\donttest{
		data(network)
		cutoff(network)
		#See vignette for more details
}

}
\author{
Bertrand Frederic, Myriam Maumy-Bertrand.
}
\keyword{methods}
