% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heat_map.R
\name{heat_map}
\alias{heat_map}
\title{Creating the \code{Heatmap} chart}
\usage{
heat_map(datap)
}
\arguments{
\item{datap}{The data set}
}
\value{
Returns an object of class \code{heatmap.2}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
\itemize{
\item \code{heat_map()} draws a double-clustered \code{heatmap}
for path coefficients analysis. Please be cautious
that this function acts only on numeric
variables/columns (see example on \code{dtraw2} data set).
Users for drawing other types of heatmaps may
use \code{heatmap.3}, \code{ComplexHeatmap} and \code{pheatmap} R packages.
Where an example is given in the vignette manual of this
package (\code{Path.Analysis_manual.Rmd})
}
}
\examples{
\donttest{
data(dtraw2)
dtraw2 <- scale(as.data.frame(dtraw2))
heat_map(dtraw2)
}
}
\seealso{
\code{lavaan} and \code{diagram} packages for drawing path diagrams.
}
\author{
{
Ali Arminian \href{mailto:abeyran@gmail.com}{abeyran@gmail.com}
}
}
