% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc.R
\name{desc}
\alias{desc}
\title{Descriptive statistics}
\usage{
desc(datap, resp)
}
\arguments{
\item{datap}{The data set}

\item{resp}{an integer value indicating the column
in \code{datap} that corresponds to the response variable.}
}
\value{
Returns a list of 3 objects:
\describe{
\item{desc1}{Descriptive statistics1 of input data}
\item{desc2}{Descriptive statistics2 of input data}
\item{corcf}{A table of correlation coefficients}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item \code{desc()} estimates the descriptive statistics such as
\code{Min}(Minimum), \verb{1st Qu.}(quartile), \code{Median}, \code{Mean}
(average), \verb{3rd Qu.}(3rd quartile), \code{Max}(maximum), \code{var}
(variance), \code{std.dev}(standard deviation), \code{coef.var}
(CV or coefficient of variation) of the data set.
}
}
\details{
The \code{desc()} function estimates the descriptive statistics,
in tables for one or more independent (exogenous) variables on
a dependent(endogenous) variable. It acts only on numerical
variables.
For example for the variable \code{x}:

\loadmathjax
\itemize{
\item \verb{1st. quartile:}
\mjsdeqn{Q_1 = (n + 1) x 1/4}
\item \verb{2nd. quartile or Median:}
\mjsdeqn{md =  (n + 1) x 2/4}
\item \verb{3rd Qu.:}
\mjsdeqn{Q_3 = (n + 1) x 3/4}
\item \verb{Arithmetic mean:}
\mjsdeqn{\bar{x}=\frac{1}{n} \sum_{i=i}^{n} x_{i}}
\item \verb{Range:}
\mjsdeqn{R_x = \max(x) - \min(x)}
\item \code{Variance}:
\mjsdeqn{\sigma_{x}^2 = \frac{\sum_{i=1}^n(x_i-\bar{x})^2}{n} 
}
\item \verb{Standard deviation:}
\mjsdeqn{sd_x = \sqrt{\frac{\sum_{i} (x_{i} - \mu)^2}{n}}}
\item \verb{SEM or SE.mean}, the standard error of the mean is
calculated simply by taking the standard deviation and
dividing it by the square root of the sample size:
\mjsdeqn{SEM_x = \frac{sd(x)}{\sqrt{n}}}
\item \verb{coef.var or coefficient of variation:}
\mjsdeqn{CV = \frac{sd(x)}{\bar{x} }\times 100}
}
}
\examples{
\donttest{
data(dtsimp)
desc(dtsimp, 1)
}
\donttest{
data(dtraw)
desc(dtraw[, -1], 1)

data(heart)
desc(heart, 2)
}

}
\references{
Bhattacharyya GK and Johnson RA 1997. Statistical Concepts
and Methods, John Wiley and Sons, New York.

Draper N and Smith H 1981. Applied Regression Analysis,
John Wiley & Sons, New York.

Neter, J, Whitmore, GA, Wasserman, W 1992. Applied Statistics.
Allyn & Bacon, Incorporated, ISBN 10: 0205134785 / ISBN 13:
9780205134786.

Snedecor, G.W., Cochran, W.G. 1980. Statistical Methods.
Iowa State University Press.
}
\seealso{
\code{correlation},  \code{multiple linear regression},
}
\author{
{
Ali Arminian \href{mailto:abeyran@gmail.com}{abeyran@gmail.com}
}
}
