% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{NPtest_indept}
\alias{NPtest_indept}
\title{Test of independence in presence of heteroscedastic treatments}
\usage{
NPtest_indept(dat, k = 7)
}
\arguments{
\item{dat}{A data frame with three columns named X, trt, and Y, where
X is the covarite, trt is the treatment level, and Y is the response
variable.}

\item{k}{An odd integer to specify the number of nearest neighbors
to be used in augmentation. Generally recommend to use 3, 5, or 7.}
}
\value{
A list containing the following variables:

       Asys_var: the asymptotic variance for the test statistics

       Tstat:  the test statistic

       pvalue: the p-value of the test under H0: independence between X and Y.
}
\description{
NPtest_indept performs the test of independence between the response
variable and a single covariate when there is potentially heteroscedastic
treatment effects present (see
Wang, Tolos and Wang (2010)).
}
\examples{
n=64;  X=runif(n); trt=gl(2, n/2)
e=rnorm(n, 0, 0.1)
Y=ifelse(trt==1, 4*(X-0.5)^2+e, 2*X+e)
dat=data.frame(X, Y, trt)
NPtest_indept(dat, k=7)

}
\references{
Haiyan Wang, Siti Tolos, and Suojin Wang (2010). A Distribution Free
 Nonparametric Test to Detect Dependence Between a Response Variable and
 Covariate in Presence of Heteroscedastic Treatment Effects.
 The Canadian Journal of Statistics. 38(3), 408433. Doi:10.1002/cjs.10068
}
