% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLF.pvalue.R
\name{MLF.pvalue}
\alias{MLF.pvalue}
\title{Modified Lilliefors Goodness-of-Fit Normality Test}
\usage{
MLF.pvalue(x)
}
\arguments{
\item{x}{a numeric vector of data values, the number of which must be greater than 4.}
}
\value{
The function returns the p-value of the modified Lilliefors goodness-of-fit normality test.
}
\description{
Calculates the p-value of the modified Lilliefors goodness-of-fit normality test.
}
\details{
The modified Lilliefors goodness-of-fit p-value.
}
\examples{
\donttest{MLF.pvalue(rnorm(33, mean = 0, sd = 2))}
\donttest{MLF.pvalue(data1)}

}
\references{
{Sulewski, P. (2019). \emph{Modified Lilliefors Goodness-of-fit Test for Normality.} Communications in Statistics - Simulation and Computation 51(3), 1199-1219.}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
