% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspc.R
\name{pspc}
\alias{pspc}
\title{Sulewski Plasticizing Component Distribution}
\usage{
pspc(x, a, b, c, d, teta)
}
\arguments{
\item{x}{real argument}

\item{a}{multipurpose parameter (a>=0)}

\item{b}{multipurpose parameter (b>=0, a+b>0)}

\item{c}{multipurpose parameter}

\item{d}{multipurpose parameter (d>=1)}

\item{teta}{position parameter}
}
\value{
The function returns the value of the cumulative distribution function for the Sulewski plasticizing component distribution.
}
\description{
Density, distribution function, quantile function and random generation
for the Sulewski plasticizing component distribution with parameters a, b, c, d and teta.
}
\details{
Probability density function
see formula (2.1) in the article
Cumulative distribution function
see formula (2.2)
Quantile functon
see formulas (2.3-2.5)
Random number generator
see proposition (4)
}
\examples{
dspc(0,1,1,1,1,0)
pspc(0,1,1,1,1,0)
qspc(0.5,1,1,1,1,0)
rspc(10,1,1,1,1,0)

}
\references{
{Sulewski, P., Volodin, A. (2022). \emph{Sulewski Plasticizing Component Distribution: properties and applications.} Lobachtetavskii Journal of Mathtetamatics 43(8), 2286-2300.}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@upsl.edu.pl}, Pomeranian UNiwersity in Slupsk.
}
