% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism.R
\name{prism}
\alias{prism}
\title{PRISM function}
\usage{
prism(
  data,
  data.early,
  GTdata,
  stl = TRUE,
  n.history = 700,
  n.training = 156,
  alpha = 1,
  UseGoogle = T,
  nPred.vec = 0:3,
  discount = 0.015,
  sepL1 = F
)
}
\arguments{
\item{data}{time series of interest as xts, last element can be NA. (e.g., unemployment initial claim data in the same period as \code{GTdata}).}

\item{data.early}{historical time series of response variable before contemporaneous exogenous data, \code{GTdata} is available. (e.g., unemployment initial claim prior to 2004)}

\item{GTdata}{contemporaneous exogenous data as xts. (e.g., Google Trend data)}

\item{stl}{if TRUE, use STL seasonal decomposition; if FALSE, use classic additive seasonal decomposition.}

\item{n.history}{training period for seasonal decomposition. (by default = 700 wks)}

\item{n.training}{length of regression training period (by default = 156)}

\item{alpha}{penalty between lasso and ridge. alpha=1 represents lasso, alpha=0 represents ridge, alpha=NA represents no penalty.}

\item{UseGoogle}{boolean variable indicating whether to use Google Trend data.}

\item{nPred.vec}{the number of periods ahead for forecast. nPred.vec could be a vector of intergers. e.g. nPred.vec=0:3 gives results from nowcast to 3-week ahead forecast.}

\item{discount}{exponential weighting: (1-discount)^lag (by default = 0.015).}

\item{sepL1}{if TRUE, use separate L1 regularization parameters for time series components and exogenous variables (Goolgle Trend data)}
}
\value{
A list of following named objects
\itemize{
\item \code{coef} coefficients for Intercept, z.lags, seasonal.lags and exogenous variables.
\item \code{pred} a vector of prediction with \code{nPred.vec} weeks forward.
}
}
\description{
A function for nowcasting and forecasting time series.
}
\examples{
prism_data = load_5y_search_data('0610')
data = prism_data$claim.data[1:200] # load claim data from 2006-01-07 to 2009-10-31
data[200] = NA # delete the data for the latest date and try to nowcast it.

data.early = prism_data$claim.earlyData # load claim prior to 2006
GTdata = prism_data$allSearch[1:200] # load Google trend data from 2006-01-07 to 2009-10-31

result = prism(data, data.early, GTdata) # call prism method
result$pred # output 0-3wk forward prediction

}
