% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medianTest.R
\name{medianTest}
\alias{medianTest}
\alias{medianTest.default}
\alias{medianTest.formula}
\title{Brown-Mood Median Test}
\usage{
medianTest(x, ...)

\method{medianTest}{default}(x, g, simulate.p.value = FALSE, B = 2000, ...)

\method{medianTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  simulate.p.value = FALSE,
  B = 2000,
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{simulate.p.value}{a logical indicating whether to compute
p-values by Monte-Carlo simulation.}

\item{B}{an integer specifying the number of replicates used
in the Monte-Carlo test.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \sQuote{htest}. For details see
\code{\link[stats]{chisq.test}}.
}
\description{
Performs Brown-Mood Median Test.
}
\details{
The null hypothesis, H\eqn{_0: \theta_1 = \theta_2 =
\ldots = \theta_k}
is tested against the alternative,
H\eqn{_\mathrm{A}: \theta_i \ne \theta_j ~~(i \ne j)}, with at least
one unequality beeing strict.
}
\examples{
## Hollander & Wolfe (1973), 116.
## Mucociliary efficiency from the rate of removal of dust in normal
## subjects, subjects with obstructive airway disease, and subjects
## with asbestosis.
x <- c(2.9, 3.0, 2.5, 2.6, 3.2) # normal subjects
y <- c(3.8, 2.7, 4.0, 2.4)      # with obstructive airway disease
z <- c(2.8, 3.4, 3.7, 2.2, 2.0) # with asbestosis
g <- factor(x = c(rep(1, length(x)),
                   rep(2, length(y)),
                   rep(3, length(z))),
             labels = c("ns", "oad", "a"))
dat <- data.frame(
   g = g,
   x = c(x, y, z))

## AD-Test
adKSampleTest(x ~ g, data = dat)

## BWS-Test
bwsKSampleTest(x ~ g, data = dat)

## Kruskal-Test
## Using incomplete beta approximation
kruskalTest(x ~ g, dat, dist="KruskalWallis")
## Using chisquare distribution
kruskalTest(x ~ g, dat, dist="Chisquare")

\dontrun{
## Check with kruskal.test from R stats
kruskal.test(x ~ g, dat)
}
## Using Conover's F
kruskalTest(x ~ g, dat, dist="FDist")

\dontrun{
## Check with aov on ranks
anova(aov(rank(x) ~ g, dat))
## Check with oneway.test
oneway.test(rank(x) ~ g, dat, var.equal = TRUE)
}

## Median Test asymptotic
medianTest(x ~ g, dat)

## Median Test with simulated p-values
set.seed(112)
medianTest(x ~ g, dat, simulate.p.value = TRUE)
}
\references{
Brown, G.W., Mood, A.M., 1951,
On Median Tests for Linear Hypotheses,
in: \emph{Proceedings of the Second Berkeley Symposium on
Mathematical Statistics and Probability}.
University of California Press, pp. 159–167.
}
\seealso{
\code{\link[stats]{chisq.test}}.
}
\keyword{nonparametric}
