% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThreeComp_Volume_Exponent.R
\name{ThreeComp_Volume_Exponent}
\alias{ThreeComp_Volume_Exponent}
\title{Convert pharmacokinetic parameters for three compartment model}
\usage{
ThreeComp_Volume_Exponent(V1,alpha,beta,gamma,k21,k31,
 V1.sd=NA,alpha.sd=NA,beta.sd=NA,gamma.sd=NA,k21.sd=NA,k31.sd=NA,
 covar=c(V1alpha=NA,V1beta=NA,V1gamma=NA,V1k21=NA,V1k31=NA,
   alphabeta=NA,alphagamma=NA,alphak21=NA,alphak31=NA,
   betagamma=NA,betak21=NA,betak31=NA,gammak21=NA,gammak31=NA,
   k21k31=NA),...)
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{alpha}{parameter in one compartment model "Aexp(-alpha)"}

\item{beta}{parameter in two compartment model "Aexp(-alpha)+Bexp(-beta)"}

\item{gamma}{parameter in three compartment model
"Aexp(-alpha)+Bexp(-beta)+Cexp(-gamma)"}

\item{k21}{transfer rate constants from compartment 2 to compartment 1}

\item{k31}{transfer rate constants from compartment 3 to compartment 1}

\item{V1.sd}{standard error of V1}

\item{alpha.sd}{standard error of alpha}

\item{beta.sd}{standard error of beta}

\item{gamma.sd}{standard error of gamma}

\item{k21.sd}{standard error of k21}

\item{k31.sd}{standard error of k31}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distribution(V1),
transfer rate constant (k12 and k31), and parameters
(alpha, beta and gamma) in the model "Aexp(-alpha)+Bexp(-beta)+Cexp(-gamma)"
}
\examples{
ThreeComp_Volume_Exponent(V1=10,alpha=0.6, beta=0.013, gamma=0.00074,
   k21=0.02, k31=0.001, V1.sd=0.01,alpha.sd=0.01,beta.sd=0.00005,
   gamma.sd=0.000002, k21.sd=0.0006,k31.sd=0.0000005)
}
\references{
\url{http://www.nonmemcourse.com/convert.xls}
}
