% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneComp_Volume_Exponent.R
\name{OneComp_Volume_Exponent}
\alias{OneComp_Volume_Exponent}
\title{Convert pharmacokinetic parameters for one compartment model}
\usage{
OneComp_Volume_Exponent(V1,alpha,V1.sd=NA,alpha.sd=NA,
         covar=c(V1alpha=NA),...)
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{alpha}{parameter in one compartment model "Aexp(-alpha)"}

\item{V1.sd}{standard error of V1}

\item{alpha.sd}{standard error of A}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distribution(V1) and
parameter (alpha) in the model "Aexp(-alpha)"
}
\examples{
OneComp_Volume_Exponent(V1=8,alpha=0.5,V1.sd=0.01,alpha.sd=0.001)

}
\references{
\url{http://www.nonmemcourse.com/convert.xls}
}
