% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfw_attr.R
\name{pfw_attr}
\alias{pfw_attr}
\title{View Filter Attributes on Manipulated Project FeederWatch Data}
\usage{
pfw_attr(data)
}
\arguments{
\item{data}{A filtered Project FeederWatch dataset.}
}
\value{
A named list of applied filters.
}
\description{
This function allows users to view all filters they've applied
to a filtered Project FeederWatch dataset by printing its
recorded filter attributes in a readable format.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download/load example dataset
data <- pfw_example

# Filter for Dark-eyed Junco
filtered_data <- pfw_species(data, "Dark-eyed Junco")

# View filters applied to your active data
pfw_attr(filtered_data)
\dontshow{\}) # examplesIf}
}
