% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDN.R
\name{draw.PDN}
\alias{draw.PDN}
\title{Draw Personalized Disease Network for one patient with network and ggplot2}
\usage{
draw.PDN(tt, labels)
}
\arguments{
\item{tt}{one row of network matrix generated from comorbidity data matrix using buildnetworks}

\item{labels}{names of each node in the network matrix}
}
\description{
Draw Personalized Disease Network based on newtwork matrix
}
\examples{
#Select a subset of data for toy example
comorbidity_data = comorbidity_data[c(1:10),]
survival_data = survival_data[c(1:10),]
#  Getting the names
k1 = datecut(comorbidity_data,survival_data[,1],survival_data[,2])
a = buildnetworks(comorbidity_data,k1)
#Plot PDN for patient 7
nn = names(comorbidity_data)
draw.PDN(a[7,],nn)
}
