% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undirected_prior.R
\name{undirected_prior}
\alias{undirected_prior}
\title{Pre-process the input prior set to ensure the input prior set corresponds to an undirected prior network}
\usage{
undirected_prior(prior)
}
\arguments{
\item{prior}{A k by 2 data.frame of prior set, in which each row corresponds to a pair of nodes (any omics features) that are connected under prior belief}
}
\value{
A 2-column data.frame of pre-processed prior set, in which the connection between any pair of nodes is undirected.
}
\description{
An utility function to pre-process the input prior set. This function will ensure the input prior set corresponds to an undirected prior network. If the prior network is believed to be directed, no pre-processing of the prior set is needed. Remark: this function is not necessary. Prior set should be considered carefully before running the network analysis. If the prior network connections are believed to be undirected while the prior set only includes one way connections for simplicity, this function will duplicate the connections and swap the direction automatically.
}
\examples{
prior=as.data.frame(matrix(c(1,2,1,5,1,10), ncol=2, byrow=TRUE))
## a prior set of 3 connections (1-2, 1-3, 1-10)
colnames(prior)=c("row", "col")
undirected=undirected_prior(prior)
}
