% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clevel.R
\name{clevel}
\alias{clevel}
\title{Get the estimated partial correlation graph without information incorporation}
\usage{
clevel(df, lambda)
}
\arguments{
\item{df}{The main expression dataset, an n by p matrix, in which each row corresponds to a sample and each column represents expression/abundance of an omics feature.}

\item{lambda}{The regularization parameter, used in the node-wise regression. If missing, default lambda will be used which is at the order of sqrt(2*log(p)/n).}
}
\value{
A list. The list contains estimated partial correlation matrix (Est), sparse partial correlation estimation matrix with threshold (EstThresh), estimated kappa (kappa), estimated test statistics matrix of partial correlations (tscore), sample size (n) and number of nodes (p).
}
\description{
clevel() is the function to apply the method originally proposed in paper "Qiu, Y., & Zhou, X. H. (2020). Estimating c-level partial correlation graphs with application to brain imaging". It is used to get the estimated partial correlation graph without information incorporation. Remark: mathematical standardization will be automatically done within the function.
}
\examples{
library(PCGII)
library(corpcor)
library(glmnet)
library(igraph)
library(Matrix)
library(mvtnorm)
# Simulating data
set.seed(1234567)
n=50 # sample size
p=30 # number of nodes

Omega=make_random_precision_mat(eta=.01, p=p)

# population covariance matrix, which is used to generate data
Sigma=solve(Omega)
# simulate expression data
X = rmvnorm(n = n, sigma = Sigma)

lam=2*sqrt(log(p)/n) ## fixed lambda

CLEVEL_out=clevel(df=X, lambda = lam)
inference_out=inference(list=CLEVEL_out)
diag(inference_out)=0
net=graph_from_adjacency_matrix(inference_out, mode = "undirected")
   plot(net,
        vertex.size=4,
        vertex.label.dist=0.5,
        vertex.color="red",
        edge.arrow.size=0.5,
        layout=layout_in_circle(net))
}
