% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearSpike.R
\name{LinSpike}
\alias{LinSpike}
\title{Generation of a Spike Signal with Linear Rise and Decline}
\usage{
LinSpike(baseline, peak, period, duty_cycle, peak_pos, trend, duration,
  resolution)
}
\arguments{
\item{baseline}{minimal oscillation value}

\item{peak}{maximal oscillation value}

\item{period}{oscillation period of the oscillating species (reciprocal of the frequency)}

\item{duty_cycle}{ratio of the active phase (oscillator above baseline) to the total oscillation period}

\item{peak_pos}{position of the peak value in the active phase of an oscillation cycle (example: \code{peak_pos = 0.5}, peak position is in the middle of the active phase)}

\item{trend}{percental decrease or increase in the peak value for the successive oscillation cycles; if set to 1, peak value remains unchanged}

\item{duration}{duration of the generated time course}

\item{resolution}{temporal resolution of the generated time course}
}
\value{
Returns a matrix with two columns: a time vector and an oscillator abundance vector.
}
\description{
This function takes in numeric arguments for a customizable, spike shape, in which rise and decline are modelled by means of a linear function. A discretized time course is returned.
}
\details{
Standards:
\itemize{
 \item{\code{peak} must be larger than \code{baseline}}
 \item{\code{duration} must be larger than \code{resolution}}
 \item{\code{duration} must be a multiple of \code{resolution}}
 \item{\code{period} must be a multiple of \code{resolution}}
 \item{\code{duration}, \code{resolution}, \code{peak} and \code{period} must be larger than 0}
 \item{\code{baseline} must be larger or equal to 0}
 \item{\code{duty_cycle} must be larger than 0 and smaller or equal to 1}
 \item{\code{trend} must be larger than 0}
 \item{\code{peak_pos} must be larger or equal to 0 and smaller than 1}
}
}
\examples{
# test effect of changes in period
m1 = LinSpike(baseline = 200, peak = 1000, period = 50, duty_cycle = 0.6,
peak_pos = 0.3, trend = 1, duration = 500, resolution = 0.1)
m2 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
peak_pos = 0.3, trend = 1, duration = 500, resolution = 0.1)
m3 = LinSpike(baseline = 200, peak = 1000, period = 200, duty_cycle = 0.6,
peak_pos = 0.3, trend = 1, duration = 500, resolution = 0.1)

par(mfrow = c(3,1))
plot(m1, type = "l", xlab = "time", ylab = "abundance")
plot(m2, type = "l", xlab = "time", ylab = "abundance")
plot(m3, type = "l", xlab = "time", ylab = "abundance")

# test effect of changes in duty_cycle
m1 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.3,
peak_pos = 0.3, trend = 1, duration = 500, resolution = 0.1)
m2 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
peak_pos = 0.3, trend = 1, duration = 500, resolution = 0.1)
m3 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.9,
peak_pos = 0.3, trend = 1, duration = 500, resolution = 0.1)

par(mfrow = c(3,1))
plot(m1, type = "l", xlab = "time", ylab = "abundance")
plot(m2, type = "l", xlab = "time", ylab = "abundance")
plot(m3, type = "l", xlab = "time", ylab = "abundance")

# test effect of changes in peak_pos
m1 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
peak_pos = 0.3, trend = 1, duration = 500, resolution = 0.1)
m2 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
peak_pos = 0.6, trend = 1, duration = 500, resolution = 0.1)
m3 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
peak_pos = 0.9, trend = 1, duration = 500, resolution = 0.1)

par(mfrow = c(3,1))
plot(m1, type = "l", xlab = "time", ylab = "abundance")
plot(m2, type = "l", xlab = "time", ylab = "abundance")
plot(m3, type = "l", xlab = "time", ylab = "abundance")

# test effect of changes in trend
m1 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
peak_pos = 0.3, trend = 0.7, duration = 500, resolution = 0.1)
m2 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
peak_pos = 0.3, trend = 1, duration = 500, resolution = 0.1)
m3 = LinSpike(baseline = 200, peak = 1000, period = 100, duty_cycle = 0.6,
peak_pos = 0.3, trend = 1.3, duration = 500, resolution = 0.1)

par(mfrow = c(3,1))
plot(m1, type = "l", xlab = "time", ylab = "abundance")
plot(m2, type = "l", xlab = "time", ylab = "abundance")
plot(m3, type = "l", xlab = "time", ylab = "abundance")
}
